/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.EventHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.wrapper.BlockScriptedDoorWrapper;
import noppes.npcs.blocks.tiles.TileDoor;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptBlockHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.data.DataTimers;

public class TileScriptedDoor
extends TileDoor
implements ITickable,
IScriptBlockHandler {
    private IBlock blockDummy = null;
    public float blockHardness = 5.0f;
    public float blockResistance = 10.0f;
    public boolean enabled = false;
    public long lastInited = -1L;
    public int newPower = 0;
    public int prevPower = 0;
    public String scriptLanguage = "ECMAScript";
    public String closeSound = "";
    public String openSound = "";
    public List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
    public boolean shouldRefreshData = false;
    private short ticksExisted = 0;
    public DataTimers timers = new DataTimers(this);

    @Override
    public void clearConsole() {
        for (ScriptContainer script : this.getScripts()) {
            script.console.clear();
        }
    }

    @Override
    public IBlock getBlock() {
        if (this.blockDummy == null) {
            this.blockDummy = new BlockScriptedDoorWrapper(this.func_145831_w(), this.func_145838_q(), this.func_174877_v());
        }
        return this.blockDummy;
    }

    @Override
    public TreeMap<Long, String> getConsoleText() {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        int tab = 0;
        for (ScriptContainer script : this.getScripts()) {
            ++tab;
            for (Map.Entry<Long, String> entry : script.console.entrySet()) {
                String log = map.containsKey(entry.getKey()) ? map.get(entry.getKey()) + "\n\nScriptTab " + tab + ":\n" + entry.getValue() : " ScriptTab " + tab + ":\n" + entry.getValue();
                map.put(entry.getKey(), log);
            }
        }
        return map;
    }

    @Override
    public void clearConsoleText(Long key) {
        for (ScriptContainer script : this.getScripts()) {
            script.console.remove(key);
        }
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public String getLanguage() {
        return this.scriptLanguage;
    }

    public NBTTagCompound getNBT(NBTTagCompound compound) {
        compound.func_74782_a("Scripts", (NBTBase)NBTTags.NBTScript(this.scripts));
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74778_a("CloseSound", this.closeSound);
        compound.func_74778_a("OpenSound", this.openSound);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        compound.func_74768_a("BlockPrevPower", this.prevPower);
        compound.func_74776_a("BlockHardness", this.blockHardness);
        compound.func_74776_a("BlockResistance", this.blockResistance);
        return compound;
    }

    @Override
    public List<ScriptContainer> getScripts() {
        return this.scripts;
    }

    public String getSound(boolean isOpen) {
        if (isOpen) {
            return this.openSound;
        }
        return this.closeSound;
    }

    @Override
    public boolean isClient() {
        return this.func_145831_w().field_72995_K;
    }

    public boolean isEnabled() {
        return this.enabled && ScriptController.HasStart && !this.field_145850_b.field_72995_K;
    }

    @Override
    public ITextComponent noticeString(String type, Object event) {
        TextComponentString message = new TextComponentString("");
        message.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        if (type != null) {
            TextComponentString hook = new TextComponentString("Hook \"");
            hook.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString hookType = new TextComponentString(type);
            hookType.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString hookEnd = new TextComponentString("\"; ");
            hookEnd.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            message = message.func_150257_a((ITextComponent)hook).func_150257_a((ITextComponent)hookType).func_150257_a((ITextComponent)hookEnd);
        }
        BlockPos pos = this.func_174877_v();
        TextComponentString mesDoor = new TextComponentString("Scripted Door in ");
        mesDoor.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int dimID = this.field_145850_b == null ? 0 : this.field_145850_b.field_73011_w.getDimension();
        TextComponentString posClick = new TextComponentString("dimension ID:" + dimID + "; X:" + x + "; Y:" + y + "; Z:" + z);
        posClick.func_150256_b().func_150238_a(TextFormatting.BLUE).func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/noppes world tp @p " + dimID + " " + x + " " + (y + 1) + " " + z)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("script.hover.error.pos.tp", new Object[0])));
        TextComponentString side = new TextComponentString("; Side: " + (this.isClient() ? "Client" : "Server"));
        side.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        return message.func_150257_a((ITextComponent)mesDoor).func_150257_a((ITextComponent)posClick).func_150257_a((ITextComponent)side);
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.setNBT(compound);
        this.timers.readFromNBT(compound);
    }

    @Override
    public void runScript(String type, Event event) {
        if (!this.isEnabled()) {
            return;
        }
        if (ScriptController.Instance.lastLoaded > this.lastInited) {
            this.lastInited = ScriptController.Instance.lastLoaded;
            if (!type.equalsIgnoreCase(EnumScriptType.INIT.function)) {
                EventHooks.onScriptBlockInit(this);
            }
        }
        for (ScriptContainer script : this.scripts) {
            script.run(type, event);
        }
    }

    @Override
    public void setEnabled(boolean bo) {
        this.enabled = bo;
    }

    @Override
    public void setLanguage(String lang) {
        this.scriptLanguage = lang;
    }

    @Override
    public void setLastInited(long timeMC) {
        this.lastInited = timeMC;
    }

    public void setNBT(NBTTagCompound compound) {
        this.scripts = NBTTags.GetScript(compound.func_150295_c("Scripts", 10), this, false);
        this.scriptLanguage = compound.func_74779_i("ScriptLanguage");
        this.closeSound = compound.func_74779_i("CloseSound");
        this.openSound = compound.func_74779_i("OpenSound");
        this.enabled = compound.func_74767_n("ScriptEnabled");
        this.prevPower = compound.func_74762_e("BlockPrevPower");
        if (compound.func_74764_b("BlockHardness")) {
            this.blockHardness = compound.func_74760_g("BlockHardness");
            this.blockResistance = compound.func_74760_g("BlockResistance");
        }
    }

    public void setSound(boolean isOpen, String song) {
        if (song == null) {
            song = "";
        }
        if (isOpen) {
            this.openSound = song;
        } else {
            this.closeSound = song;
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.ticksExisted = (short)(this.ticksExisted + 1);
        if (this.prevPower != this.newPower) {
            EventHooks.onScriptBlockRedstonePower(this, this.prevPower, this.newPower);
            this.prevPower = this.newPower;
        }
        this.timers.update();
        if (this.ticksExisted >= 10) {
            if (this.isEnabled()) {
                ScriptController.Instance.tryAdd(1, this);
                EventHooks.onScriptBlockUpdate(this);
            }
            this.ticksExisted = 0;
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        this.getNBT(compound);
        this.timers.writeToNBT(compound);
        return super.func_189515_b(compound);
    }
}

